/*=========================================================

	memory.h

	malloc()/calloc()/realloc()/memalign()/free()ǂB
	
	EBOOT.PBP쐬ꍇAPSP_HEAP_SIZE_KB( [kilo bytes] )ɂPSPSDK̃Cu
	malloc()pɊmۂ郁炵ĂȂƁAmۂłeʂB
	
	ǁAPSPSDK̃Cu̕gɌ܂Ă̂łǂłB

=========================================================*/
#ifndef MEMORY_H
#define MEMORY_H

#include <pspkernel.h>
#include <string.h>
#include <math.h>

/*=========================================================
	}N
=========================================================*/
#define MEMORY_PAGE_SIZE 256

/* ǂq؂AAC𒲐}N */
#define MEMORY_ALIGN_ADDR( align, addr ) ( ( (uintptr_t)( addr ) + ( align ) - 1 ) & ( ~( ( align ) - 1 ) ) )

#ifdef __cplusplus
extern "C" {
#endif

/*=========================================================
	^錾
=========================================================*/
typedef enum {
	MEMORY_KERN_HI = 1,
	MEMORY_USER,
	MEMORY_KERN_HI_MIRROR,
	MEMORY_KERN_LO,
	MEMORY_VOLATILE,
	MEMORY_USER_MIRROR
} MemoryPartition;

/*=========================================================
	vg^Cv
=========================================================*/
/*-----------------------------------------------
	memoryAlloc
	
	malloc()ǂB
	蓖ĂB
-----------------------------------------------*/
void *memoryAlloc( SceSize size );

/*-----------------------------------------------
	memoryCalloc
	
	calloc()ǂB
	蓖āÄ[NAB
-----------------------------------------------*/
void *memoryCalloc( SceSize nelem, SceSize size );

/*-----------------------------------------------
	memoryRealloc
	
	realloc()ǂB
	蓖Ă̈𑝌B
	
	TCYɐꍇÄ̗͎IɉB
	sꍇ́AԂlNULLԂ̂́AˑRƂČ̗̈悪Lł邽߃[NɒӁB
	ꍇɂmemoryReallocf()ĝȂB
	
	|C^AhX͂قƂǂ̏ꍇÃAhXƂ͈ႤAhXԂB
	OƂāAubNTCY(256oCg)ȉ̑ŁAȂAύX̃TCYA
	ubNE܂Ȃꍇ̓AhX͕ύXȂB
-----------------------------------------------*/
void *memoryRealloc( void *src_memblock, SceSize new_size );

/*-----------------------------------------------
	memoryReallocf
	
	FreeBSDŎĂreallocf()ǂB
	́AvꂽTCYփTCYoȂꍇA
	̗̈Iɉ_āAmemoryRealloc()ƓB
-----------------------------------------------*/
void *memoryReallocf( void *src_memblock, SceSize new_size );

/*-----------------------------------------------
	memoryAlign
	
	memalign()ǂB
	mۂƁA
	w肳ꂽACgɍ킹|C^AhXԂB
-----------------------------------------------*/
void *memoryAlign( unsigned int align, SceSize size );

/*-----------------------------------------------
	memoryFree
	
	free()ǂB
	mۂꂽB
-----------------------------------------------*/
int memoryFree( void *memblock );

/*-----------------------------------------------
	memoryUsableSize
	
	ۂɊmۂꂽ̈̃TCY擾B
	vTCY傫AȂƂ߂y[WTCY̔{ɂȂB
-----------------------------------------------*/
SceSize memoryUsableSize( const void *memblock );

/*-----------------------------------------------
	memoryAllocEx
	
	ۂɃ̊蓖Ăs֐B
	memoryAlloc()/memoryCalloc()/memoryRealloc()/memoryReallocf()/memoryAlign()
	ŏIIɂ̊֐ĂяoB
	
	ɁAsceKernelAllocPartitionMemory()gĎۂɃmۂB
	mۂTCÝAw肳ꂽTCYɉāA
	ǗL^邽߂ɁA8oCgmۂB
	AmۂTCY͕Ky[W(256oCg)؂ƂȂB
	
	partitiońÅ֐𒼐ڌĂŃ蓖Ăꍇɂ̂ݕύX\ŁA
	memoryAlloc()ȂǂŊmۂꍇ́AKMEMORY_USERgpB
	MEMORY_VOLATILÉAŊmۂscePowerVolatileMemLock()ƂAPIgׂB
	
	alignŃACgw肷邱ƂłB
	ACg0w肵ꍇ́ÃCu͓ɒsȂB
	
	type͈ȉ3w\B
		PSP_SMEM_Low
		PSP_SMEM_High
		PSP_SMEM_Addr
	PSP_SMEM_Low̓AhX̏烁mۂ悤݁A
	tPSP_SMEM_High̓AhX̑傫烁mۂ悤Ɏ݂B
	
	ŌPSP_SMEM_AddŕA悭킩Ȃ6void *addrɎw肷AhXmۂۂB
	炭ÃAhXɎgpĂꍇ̓G[ԂB
-----------------------------------------------*/
void *memoryAllocEx( const char *name, MemoryPartition partition, unsigned int align, SceSize size, int type, void *addr );

#ifdef MEMORY_DEBUG
unsigned int memoryGetAllocCount( void );
#endif

#ifdef __cplusplus
}
#endif

#endif
